<?php

namespace Application\UseCases;

use Domain\Entities\Vinculo;
use Domain\Repositories\IVinculoRepositoryInterface;

class CreateVinculo
{
    public function __construct(private IVinculoRepositoryInterface $repo)
    {
    }

    public function execute(string $designacao): Vinculo
    {
        $vinculo = new Vinculo($designacao);
        return $this->repo->save($vinculo);
    }
}
