<?php
namespace Application\UseCases;

use Application\DTOs\UserData;
use Domain\Entities\User;
use Domain\Repositories\UserRepositoryInterface;
use Illuminate\Support\Facades\Hash;

class CreateUser
{
    public function __construct(private UserRepositoryInterface $repo) {}

    public function execute(UserData $data): User
    {
        $password = $data->password ? Hash::make($data->password) : Hash::make(bin2hex(random_bytes(8)));

        $user = new User(
            id: null,
            name: $data->name,
            email: $data->email,
            password: $password,
            role: $data->role
        );

        return $this->repo->save($user);
    }
}
