<?php

namespace Application\UseCases;

use Application\DTOs\RequestData;
use Domain\Entities\Request;
use Domain\Repositories\RequestRepositoryInterface;

class CreateRequest
{
    public function __construct(private RequestRepositoryInterface $repo) {}

    public function execute(RequestData $data): Request
    {
        
        $request = new Request(
            id: null,
            certificate_number: $data->certificate_number,
            registration_date: $data->registration_date,
            province: $data->province,
            author_name: $data->author_name,
            work_title: $data->work_title,
            genre: $data->genre,
            support: $data->support,
            classification: $data->classification,
            is_published: $data->is_published
        );

        return $this->repo->save($request);
    }
}
