<?php

namespace Application\UseCases;

use Application\DTOs\DocumentData;
use Domain\Entities\Document;
use Domain\Repositories\IDocumentRepository;

class CreateDocument
{
    public function __construct(private IDocumentRepository $repo) {}

    public function execute(DocumentData $data): Document
    {

        $document = new Document(
            id: null,
            nome: $data->nome,
            tamanho: $data->tamanho,
            extensao: $data->extensao,
            tipo_documento_id: $data->tipo_documento_id,
            caminho_arquivo: $data->caminho_arquivo
        );

        return  $this->repo->save($document);
    }
}
