<?php

namespace Application\UseCases;

use Domain\Entities\Classificacao;
use Domain\Repositories\IClassificacaoRepositoryInterface;

class CreateClassificacao
{
    public function __construct(private IClassificacaoRepositoryInterface $repo)
    {
    }

    public function execute(string $designacao, string $genero_id): Classificacao
    {
        $classificacao = new Classificacao($designacao, $genero_id);
        return $this->repo->save($classificacao);
    }
}
