<?php

namespace Application\UseCases;

use Application\DTOs\AuthorData;
use Application\DTOs\AutorData;
use Domain\Entities\Author;
use Domain\Entities\Autor;
use Domain\Repositories\AuthorRepositoryInterface;
use Domain\Repositories\IAutorRepository;
use PharIo\Manifest\Author as ManifestAuthor;

class CreateAuthor
{
    public function __construct(private IAutorRepository $repo) {}

    public function execute(AutorData $data): Autor
    {
        $author = new Autor(
            id: null,
            nome: $data->nome,
            email: $data->email,
            provincia_id: $data->provincia_id,
            autor_representante: $data->representante_legal,
            data_nascimento: $data->data_nascimento,
            telefone: $data->telefone,
            nacionalidade_id: $data->nacionalidade_id,
            numero_identificacao: $data->numero_identificacao,
            pseudonimo: $data->pseudonimo,
            naturalidade: $data->naturalidade,
            nome_pai: $data->nome_pai,
            nome_mae: $data->nome_mae,
            ocupacao: $data->ocupacao,
            endereco: $data->endereco,
            bairro: $data->bairro,
            municipio_id: $data->municipio_id,
            celular: $data->celular,
            site: $data->site,
        );

        $author->validate();
        $representanteLegal = null;

        if ($author->autor_representante && $author->autor_representante->numeroIdentificacao) {
            $representanteLegal = $this->repo->findRepresentanteLegal($author->autor_representante->numeroIdentificacao);
        }

        return $this->repo->save($author, $representanteLegal);
    }
}
