<?php

namespace Application\UseCases;

use Application\DTOs\AddDocumentoObraDTO;
use Domain\Entities\Document;
use Domain\Repositories\IObraRepository;
use Domain\Repositories\IDocumentRepository;
use Domain\Services\IFileStorageService;
use Infrastructure\Persistence\Eloquent\Models\ObraDocumentoModel;
use DomainException;

class AddDocumentoObra
{
    public function __construct(
        private IObraRepository $obraRepository,
        private IDocumentRepository $documentRepository,
        private IFileStorageService $fileStorageService
    ) {}

    public function execute(AddDocumentoObraDTO $dto): array
    {
        $obra = $this->obraRepository->findById($dto->obra_id);
        if (!$obra) {
            throw new DomainException('Obra não encontrada');
        }

        $fileName = time() . '_' . $dto->file->getClientOriginalName();
        $directory = "obras/{$dto->obra_id}";
        $uploadPath = $this->fileStorageService->storeFile($dto->file, $directory, $fileName);

        $document = new Document(
            null,
            $dto->file->getClientOriginalName(),
            $uploadPath,
            $dto->tipo_documento_id,
            (string) $dto->file->getSize(),
            $dto->file->getClientOriginalExtension()
        );

        $savedDocument = $this->documentRepository->save($document);

        if ($dto->ordem === null) {
            $maxOrdem = ObraDocumentoModel::where('obra_id', $dto->obra_id)->max('ordem') ?? 0;
            $dto->ordem = $maxOrdem + 1;
        }

        ObraDocumentoModel::create([
            'obra_id' => $dto->obra_id,
            'documento_id' => $savedDocument->id,
            'tipo_documento_id' => $dto->tipo_documento_id,
            'ordem' => $dto->ordem
        ]);

        return [
            'documento_id' => $savedDocument->id,
            'obra_id' => $dto->obra_id,
            'nome' => $savedDocument->nome,
            'tipo_documento_id' => $dto->tipo_documento_id,
            'ordem' => $dto->ordem,
            'caminho' => $savedDocument->caminho_arquivo
        ];
    }
}
