<?php

namespace Application\UseCases;

use Application\DTOs\AddAutorObraDTO;
use Domain\Entities\AutorObra;
use Domain\Repositories\IObraRepository;
use Domain\Repositories\IAutorObraRepository;
use Infrastructure\Persistence\Eloquent\Models\AutorModel;
use Infrastructure\Persistence\Eloquent\Models\VinculoModel;
use DomainException;

class AddAutorObra
{
    public function __construct(
        private IObraRepository $obraRepository,
        private IAutorObraRepository $autorObraRepository
    ) {}

    public function execute(AddAutorObraDTO $dto): array
    {
        $obra = $this->obraRepository->findById($dto->obra_id);
        if (!$obra) {
            throw new DomainException('Obra não encontrada');
        }

        $autor = AutorModel::find($dto->autor_id);
        if (!$autor) {
            throw new DomainException('Autor não encontrado');
        }

        $vinculo = VinculoModel::find($dto->vinculo_id);
        if (!$vinculo) {
            throw new DomainException('Vínculo não encontrado');
        }

        $existingRelation = $this->autorObraRepository->findByObra($dto->obra_id);
        foreach ($existingRelation as $relation) {
            if ($relation->autor_id === $dto->autor_id) {
                throw new DomainException('O autor já está associado a esta obra');
            }
        }

        $autorObra = new AutorObra(
            $dto->autor_id,
            $dto->obra_id,
            $dto->vinculo_id,
            $dto->observacoes
        );

        $savedAutorObra = $this->autorObraRepository->save($autorObra);

        return [
            'id' => $savedAutorObra->id,
            'autor_id' => $savedAutorObra->autor_id,
            'obra_id' => $savedAutorObra->obra_id,
            'vinculo_id' => $savedAutorObra->vinculo_id,
            'observacoes' => $savedAutorObra->observacoes,
            'autor_nome' => $autor->nome,
            'vinculo_nome' => $vinculo->nome
        ];
    }
}
