<?php
namespace Application\Shared\Search;

class Search
{
    public ?string $orderBy = null;
    public ?string $orderByDirection = 'asc';
    public array $searchBy = [];
    public array $filters = []; // normalized: ['field' => ['operation' => Operator, 'value' => mixed]]
    public ?string $searchValue = null;

    public function __construct(array $data = [])
    {
        $this->orderBy = $data['orderBy'] ?? null;
        $this->orderByDirection = $data['orderByDirection'] ?? 'asc';
        $this->searchBy = $data['searchBy'] ?? [];
        $this->searchValue = $data['searchValue'] ?? null;

        $this->filters = $this->normalizeFilters($data['filters'] ?? []);
    }

    private function normalizeFilters(array $filters): array
    {
        $normalized = [];
        foreach ($filters as $field => $filter) {
            if (!isset($filter['operation']) || !array_key_exists('value', $filter)) {
                continue;
            }

            try {
                // Accept either operator enum name/string (ex: 'eq') or an Operator instance
                $operation = $filter['operation'] instanceof Operator
                    ? $filter['operation']
                    : Operator::from($filter['operation']);
            } catch (\ValueError $e) {
                // operador inválido — ignora
                continue;
            }

            $normalized[$field] = [
                'operation' => $operation,
                'value' => $filter['value'],
            ];
        }

        return $normalized;
    }
}