<?php
namespace Application\Shared\Search;

class PaginationMeta
{
    public int $total;
    public int $page;
    public int $perPage;
    public ?string $sort;
    public ?string $direction;

    public function __construct(array $data = [])
    {
        $this->total = (int)($data['total'] ?? 0);
        $this->page = (int)($data['page'] ?? 1);
        $this->perPage = (int)($data['perPage'] ?? 15);
        $this->sort = $data['sort'] ?? null;
        $this->direction = $data['direction'] ?? 'asc';
    }
}