<?php
namespace Application\DTOs\Shared;

use Application\Shared\Search\PaginationMeta;

class DataResponse
{
    public array|object|null $data;
    public ?PaginationMeta $pagination;

    public function __construct(array|object|null $data = null, ?PaginationMeta $pagination = null)
    {
        $this->data = $data;
        $this->pagination = $pagination;
    }

    public function toArray(): array
    {
        $data = $this->data;

        if (is_object($data) && method_exists($data, 'toArray')) {
            $data = $data->toArray();
        }

        return [
            'data' => $data,
            'pagination' => $this->pagination ? [
                'total' => $this->pagination->total,
                'page' => $this->pagination->page,
                'perPage' => $this->pagination->perPage,
                'sort' => $this->pagination->sort,
                'direction' => $this->pagination->direction,
            ] : null,
        ];
    }
}

